/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.SeahorseConfig;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class SeahorseEntity
extends AbstractSchoolingFish
implements IMobVariants,
ILexiconEntry {
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(SeahorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public SeahorseEntity(EntityType<SeahorseEntity> type, Level world) {
        super(type, world);
    }

    public static boolean checkSeahorseSpawnRules(EntityType<SeahorseEntity> entity, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_6425_(pos).m_205070_(LivingThingsTags.SEAHORSE_SPAWNABLE_ON) && world.m_6425_(pos.m_7494_()).m_205070_(LivingThingsTags.SEAHORSE_SPAWNABLE_ON);
    }

    public static AttributeSupplier.Builder m_27495_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, SeahorseConfig.health()).m_22268_(Attributes.f_22279_, SeahorseConfig.movementSpeed());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("SeahorseVariant", this.getVariant());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128445_("SeahorseVariant"));
    }

    protected SoundEvent m_5699_() {
        return ModSounds.SEAHORSE_FLOP.get();
    }

    public int m_5792_() {
        return SeahorseConfig.maxSpawnedInChunk();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.85f;
    }

    @Override
    public byte getVariant() {
        return (Byte)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)((byte)Mth.m_14045_((int)variant, (int)0, (int)4)));
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ModItems.SEAHORSE_BUCKET.get());
    }

    public void m_6872_(ItemStack stack) {
        super.m_6872_(stack);
        CompoundTag compoundnbt = stack.m_41784_();
        compoundnbt.m_128344_("BucketSeahorseVariantTag", this.getVariant());
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.SEAHORSE;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, SpawnGroupData entityData, CompoundTag tag) {
        entityData = super.m_6518_(world, difficulty, spawnReason, entityData, tag);
        if (tag != null && tag.m_128425_("BucketSeahorseVariantTag", 1)) {
            this.setVariant(tag.m_128445_("BucketSeahorseVariantTag"));
            return entityData;
        }
        byte variant = 0;
        if (entityData instanceof SeahorseData) {
            variant = ((SeahorseData)((Object)entityData)).variant;
            entityData = new SeahorseData(this, variant);
        } else {
            int blueWeight = (Integer)SeahorseConfig.get().colorBlueWeight.get();
            int greenWeight = (Integer)SeahorseConfig.get().colorGreenWeight.get();
            int purpleWeight = (Integer)SeahorseConfig.get().colorPurpleWeight.get();
            int yellowWeight = (Integer)SeahorseConfig.get().colorYellowWeight.get();
            int redWeight = (Integer)SeahorseConfig.get().colorRedWeight.get();
            variant = this.getRandomVariant(this.f_19796_, new byte[]{0, 1, 2, 3, 4}, new int[]{blueWeight, greenWeight, purpleWeight, yellowWeight, redWeight});
        }
        this.setVariant(variant);
        return entityData;
    }

    private static final class SeahorseData
    extends AbstractSchoolingFish.SchoolSpawnGroupData {
        private final byte variant;

        public SeahorseData(AbstractSchoolingFish fish, byte variant) {
            super(fish);
            this.variant = variant;
        }
    }
}

